<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Admin;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\Admin\AdminTable;

final class AdminFinder extends AbstractFinder implements InterfaceAdminSetter
{
    /**
     * setter interface
     */
    use TraitAdminSetters;

    public function getTableName(): string
    {
        return AdminTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {AdminTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): AdminModel
    {
        return AdminModel::createFromUntouchedBean_noException(parent::pop());
    }
}
